let metadb = require('common/metadb');

const settingsPath = 'MAIN_MODULE_MANAGEMENT/customers/cdev.console/Config/aguilaConsole';

let aon = {
  type: 'agorum.vbox',
  title: '',
  width: 400,
  // height: 300,
  items: [
    {
      type: 'agorum.textDisplay',
      value: 'Default require',
    },
    {
      type: 'agorum.textArea',
      name: 'default_require',
      monospaced: true,
      border: true,
      flexible: true,
    },
  ],
};

function load() {
  let cs = Object.assign(
    {
      default_require: '',
      channel: 'aguila-log-channel',
    },
    JSON.parse(metadb.read(settingsPath))
  );
  return cs;
}

function init(sw, cs) {
  sw.items.default_require.text = cs.default_require;
}

function update(sw, cs) {
  cs.default_require = sw.items.default_require.text;
  metadb.write(settingsPath, JSON.stringify(cs));
  console.log(cs);
}

module.exports = {
  aon: aon,
  load: load,
  init: init,
  update: update,
};

if (module.id === 'main') {
  console.log('main');
  let cs = load();
  let sw = require('../widget-helper').create(aon, 'Settings');
  init(sw, cs);
  sw.widget.on('destroying', () => {
    update(sw, cs);
  });
  sw.widget;
}
